/*
 * Decompiled with CFR 0.152.
 */
package com.belenus.dataconnect;

import com.belenus.dataconnect.AbstractRowContainer;
import com.belenus.dataconnect.DatabaseManager;
import com.belenus.dataconnect.Row;
import com.belenus.dataconnect.RowException;
import com.belenus.dataconnect.Template;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.log4j.Logger;

public class ResultSetRowContainer
extends AbstractRowContainer {
    private static final Logger logger = Logger.getLogger((Class)(class$com$belenus$dataconnect$ResultSetRowContainer == null ? (class$com$belenus$dataconnect$ResultSetRowContainer = ResultSetRowContainer.class$("com.belenus.dataconnect.ResultSetRowContainer")) : class$com$belenus$dataconnect$ResultSetRowContainer));
    private boolean m_working = true;
    private boolean m_resultContinuesAfterLast = true;
    private DatabaseManager m_databaseManager;
    private Connection m_connection;
    private Statement m_statement;
    private ResultSet m_resultSet;
    private String[] m_columnNames;
    private int m_maxRows;
    static /* synthetic */ Class class$com$belenus$dataconnect$ResultSetRowContainer;

    private void fillResultSet(Template template, boolean withLogging) throws SQLException {
        boolean isResultSet;
        if (this.m_databaseManager.usePreparedStatements()) {
            if (withLogging && this.m_databaseManager.isLogged()) {
                String query = template.fill();
                this.m_databaseManager.log("RowContainer Query (prepared): " + query);
            }
            PreparedStatement preparedStatement = template.fill(this.m_connection);
            preparedStatement.setMaxRows(this.m_maxRows + 1);
            isResultSet = preparedStatement.execute();
            this.m_statement = preparedStatement;
        } else {
            String query = template.fill();
            if (withLogging) {
                this.m_databaseManager.log("RowContainer Query: " + query);
            }
            Statement statement = this.m_connection.createStatement();
            statement.setMaxRows(this.m_maxRows + 1);
            isResultSet = statement.execute(query);
            this.m_statement = statement;
        }
        if (isResultSet) {
            this.m_resultSet = this.m_statement.getResultSet();
        } else {
            this.m_columnNames = new String[0];
            this.destroy();
        }
    }

    public ResultSetRowContainer(DatabaseManager databaseManager, Template template) {
        this(databaseManager, template, 100000);
    }

    public ResultSetRowContainer(DatabaseManager databaseManager, Template template, int maxRows) {
        String query = template.fill();
        this.m_databaseManager = databaseManager;
        this.m_maxRows = maxRows;
        try {
            this.m_connection = this.m_databaseManager.getConnection();
            this.fillResultSet(template, true);
        }
        catch (SQLException sqlException) {
            this.m_working = false;
            this.close();
            try {
                this.m_connection = this.m_databaseManager.getConnection();
                this.fillResultSet(template, false);
            }
            catch (SQLException sqlException2) {
                this.m_working = false;
                this.close();
                throw new RowException("Cannot retrieve row.", sqlException);
            }
        }
        while (!this.isFinished()) {
            this.nextResult();
        }
        this.m_databaseManager.log("RowContainer loaded. " + this.m_rows.size() + " rows found." + (this.resultContinuesAfterLast() ? " (continued)" : ""));
    }

    private void close() {
        this.m_databaseManager.close(this.m_statement, this.m_resultSet, this.m_working);
        this.m_resultSet = null;
        this.m_statement = null;
        this.m_connection = null;
    }

    public void destroy() {
        this.close();
        super.destroy();
    }

    protected synchronized void nextResult() {
        if (!this.isFinished()) {
            try {
                if (this.m_resultSet.next()) {
                    this.ensureColumnNames();
                    Object[] fields = new Object[this.m_columnNames.length];
                    for (int columnIndex = 0; columnIndex < this.m_columnNames.length; ++columnIndex) {
                        fields[columnIndex] = this.m_resultSet.getObject(columnIndex + 1);
                    }
                    Row row = new Row(this, fields);
                    this.m_rows.add(row);
                    if (this.m_rows.size() >= this.m_maxRows) {
                        this.m_resultContinuesAfterLast = true;
                        this.close();
                    }
                } else {
                    this.ensureColumnNames();
                    this.m_resultContinuesAfterLast = false;
                    this.close();
                }
            }
            catch (SQLException sqlException) {
                this.m_working = false;
                this.close();
                throw new RowException("No next rows available in RowContainer or problem retrieving row.", sqlException);
            }
        }
    }

    private void ensureColumnNames() throws SQLException {
        if (this.m_columnNames == null) {
            ResultSetMetaData resultSetMetaData = this.m_resultSet.getMetaData();
            int columnCount = resultSetMetaData.getColumnCount();
            this.m_columnNames = new String[columnCount];
            for (int columnIndex = 0; columnIndex < columnCount; ++columnIndex) {
                this.m_columnNames[columnIndex] = resultSetMetaData.getColumnName(columnIndex + 1).toLowerCase();
            }
        }
    }

    public synchronized String[] getColumnNames() {
        if (this.m_columnNames == null) {
            throw new IllegalStateException("First row needs to be read");
        }
        return this.m_columnNames;
    }

    protected boolean isFinished() {
        return this.m_resultSet == null;
    }

    public boolean resultContinuesAfterLast() {
        while (!this.isFinished()) {
            this.nextResult();
        }
        return this.m_resultContinuesAfterLast;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

